//     pickerUI beta   2010.03.13
//
//
//     選択中の平面レイヤーのカラーを、パネル内のカラーグリッドでクリックした色に変更 (複数選択は不可)
//
//     今後、いろいろと改良する予定
//
//




var myPalette = this;

var cX;
var cY;
var pX;
var pY;

var valC = false;

//パネル内イベント
function myFunc(e)
{

    myPalette.group3.text0.text = e.view.toString();
    myPalette.group3.text1.text = "x: " + e.clientX;
    myPalette.group3.text2.text = "y: " + e.clientY;
    
}

//カラーグリッド内ドラッグイベント
function myFunc2(c)
{
    cX = c.clientX - 7 + 5;  //+5 は、カーソル位置の見た目調整分
    cY = c.clientY - 5 + 5;  //+5 は、カーソル位置の見た目調整分
    
    pX = c.clientX + 5;
    pY = c.clientY + 5;
    
    if(cX - 5 < 0){            //見た目調整分を差し引き
    	cX = 0;
    }else if(cX - 5 > 180){  //見た目調整分を差し引き
    	cX = 180;
    }
    if(cY - 5 < 0){            //見た目調整分を差し引き
    	cY = 0;
    }else if(cY - 5 > 180){  //見た目調整分を差し引き
    	cY = 180;
    }
    
    if(valC){
    	
		var vH = 1;
		var vS = 1;
		var vB = 1;
		
	    
	    if(cX < 0){
	    	cX = 0;
	    }else if(cX > 180){
	    	cX = 180;
	    }
	    if(cY < 0){
	    	cY = 0;
	    }else if(cY > 180){
	    	cY = 180;
	    }
	    
	    if(pX < 5){
	    	pX = 5;
	    }else if(pX > 185){
	    	pX = 185;
	    }
	    if(pY < 5){
	    	pY = 5;
	    }else if(pY > 185){
	    	pY = 185;
	    }
	    
	    myPalette.group1.iconP.location = [pX, pY];
	    //alert(myPalette.group1.iconP.location);
	
	    vH = cX * 2;
	    myPalette.group3.textH.text = "H: " + vH
	    if(myPalette.group2.btnS.value){
	    	vS = 1;
	    	vB = 1 - (cY / 180);
		    myPalette.group3.textS.text = "S: " + vS;
		    myPalette.group3.textB.text = "B: " + vB;
	    }else if(myPalette.group2.btnB.value){
	    	vS = 1 - (cY / 180);
	    	vB = 1;
		    myPalette.group3.textS.text = "S: " + vS;
		    myPalette.group3.textB.text = "B: " + vB;
	    }
	    
	    //これをカラーの ”HSB” に突っこむ
	    newColor = [vH, vS, vB];
	    
	    HSBtoRGB(vH, vS, vB);
    	
    }
}

//カラーグリッド内クリックイベント
function myPick()
{
	valC = true;
	
	var vH = 1;
	var vS = 1;
	var vB = 1;
	
    
    if(cX < 0){
    	cX = 0;
    }else if(cX > 180){
    	cX = 180;
    }
    if(cY < 0){
    	cY = 0;
    }else if(cY > 180){
    	cY = 180;
    }
    
    if(pX < 5){
    	pX = 5;
    }else if(pX > 185){
    	pX = 185;
    }
    if(pY < 5){
    	pY = 5;
    }else if(pY > 185){
    	pY = 185;
    }
    
    myPalette.group1.iconP.location = [pX, pY];
    //alert(myPalette.group1.iconP.location);

    vH = cX * 2;
    myPalette.group3.textH.text = "H: " + vH
    if(myPalette.group2.btnS.value){
    	vS = 1;
    	vB = 1 - (cY / 180);
	    myPalette.group3.textS.text = "S: " + vS;
	    myPalette.group3.textB.text = "B: " + vB;
    }else if(myPalette.group2.btnB.value){
    	vS = 1 - (cY / 180);
    	vB = 1;
	    myPalette.group3.textS.text = "S: " + vS;
	    myPalette.group3.textB.text = "B: " + vB;
    }
    
    //これをカラーの ”HSB” に突っこむ
    newColor = [vH, vS, vB];
    
    HSBtoRGB(vH, vS, vB);

}

//カラーグリッド内リリースイベント
function myPick2()
{
	valC = false;
	
	var vH = 1;
	var vS = 1;
	var vB = 1;
	
    
    if(cX < 0){
    	cX = 0;
    }else if(cX > 180){
    	cX = 180;
    }
    if(cY < 0){
    	cY = 0;
    }else if(cY > 180){
    	cY = 180;
    }
    
    if(pX < 5){
    	pX = 5;
    }else if(pX > 185){
    	pX = 185;
    }
    if(pY < 5){
    	pY = 5;
    }else if(pY > 185){
    	pY = 185;
    }
    

    vH = cX * 2;
    myPalette.group3.textH.text = "H: " + vH
    if(myPalette.group2.btnS.value){
    	vS = 1;
    	vB = 1 - (cY / 180);
	    myPalette.group3.textS.text = "S: " + vS;
	    myPalette.group3.textB.text = "B: " + vB;
    }else if(myPalette.group2.btnB.value){
    	vS = 1 - (cY / 180);
    	vB = 1;
	    myPalette.group3.textS.text = "S: " + vS;
	    myPalette.group3.textB.text = "B: " + vB;
    }
    
    //これをカラーの ”HSB” に突っこむ
    newColor = [vH, vS, vB];
    
    HSBtoRGB(vH, vS, vB);
    
}



//カラーグリッド内イベント
function myPick3()
{
	var vH = 1;
	var vS = 1;
	var vB = 1;
	
    pLoc = myPalette.group1.iconP.location;
    cX = pLoc[0] - 5;
    cY = pLoc[1] - 5;

    vH = cX * 2;
    myPalette.group3.textH.text = "H: " + vH
    if(myPalette.group2.btnS.value){
    	vS = 1;
    	vB = 1 - (cY / 180);
	    myPalette.group3.textS.text = "S: " + vS;
	    myPalette.group3.textB.text = "B: " + vB;
    }else if(myPalette.group2.btnB.value){
    	vS = 1 - (cY / 180);
    	vB = 1;
	    myPalette.group3.textS.text = "S: " + vS;
	    myPalette.group3.textB.text = "B: " + vB;
    }
    
    //これをカラーの ”HSB” に突っこむ
    newColor = [vH, vS, vB];
    
    HSBtoRGB(vH, vS, vB);
    
    

}



//HSVカラーからRGBカラーへの変換
function HSBtoRGB(nH,nS,nB)
{
	
			if (nH == 360) {
				nH = 0;
			}
			nH /= 60;
			
			var i = parseInt(nH);
			var f = nH - i;
			var p = nB * (1 - nS);
			var q = nB * (1 - (nS * f));
			var t = nB * (1 - (nS * (1 - f)));
			switch (i) {
				case 0:
					R = nB;
					G = t;
					B = p;
					break;
				case 1:
					R = q;
					G = nB;
					B = p;
					break;
				case 2:
					R = p;
					G = nB;
					B = t;
					break;
				case 3:
					R = p;
					G = q;
					B = nB;
					break;
				case 4:
					R = t;
					G = p;
					B = nB;
					break;
				case 5:
					R = nB;
					G = p;
					B = q;
					break;
			}
	
	setColor(R, G, B);
	
}


//平面の色を変更
function setColor(R,G,B)
{
	var activeComp =  app.project.activeItem;
	valE = false;
	
	//コンポが選ばれていない、または、複数選んでいる場合、アラート
	if(activeComp == null){
		alert("******コンポを１つだけ選んでください******");
		valE = true;
	//コンポが１つだけ選ばれている場合
	}else{
		
		selectLys = app.project.activeItem.selectedLayers;
		
		//選択レイヤーが１つだけで、且つ、平面の場合
		if(selectLys.length ==1 && selectLys[0].source.mainSource == "[object SolidSource]"){
			//alert(R + "_" + G + "_" + B);


			//平面の色を変更
			aName = selectLys[0].name;
			aW = selectLys[0].width;
			aH = selectLys[0].height;
			aPA = selectLys[0].source.pixelAspect;
			selectLys[0].source.replaceWithSolid([R,G,B],aName,aW,aH,aPA);
		}
		
	}
	
	
}

function buildUI()
{
	myPalette.group1 = myPalette.add('panel',[0,0,195,195],"");
	imageS = new File( "../"+"(png)"+"/color_S.png");
	imageB = new File( "../"+"(png)"+"/color_B.png");
	imageP = new File( "../"+"(png)"+"/mappoint.png");
	myPalette.group1.iconP = myPalette.group1.add("image",[184,4,186,6],imageP);
	myPalette.group1.iconS = myPalette.group1.add("image",[7,5,187,185],imageS);
	myPalette.group1.iconS.visible = true;
	myPalette.group1.iconB = myPalette.group1.add("image",[7,5,187,185],imageB);
	myPalette.group1.iconB.visible = false;
	
	//マウスイベント
	myPalette.group1.addEventListener('mousemove',myFunc2);
	myPalette.group1.addEventListener('mousedown',myPick);
	myPalette.group1.addEventListener('mouseup',myPick2);
	
	
	myPalette.group2 = myPalette.add('panel',[10,195,185,230],"Color");
	
	myPalette.group2.btnS = myPalette.group2.add("radiobutton",[75,1,115,30],"S");
	myPalette.group2.btnS.value = true;
	myPalette.group2.btnS.onClick = function ()
														{
															myPalette.group2.btnS.value = true;
															myPalette.group2.btnS.active = false;
															myPalette.group2.btnB.value = false;
															myPalette.group1.iconS.visible = true;
															myPalette.group1.iconB.visible = false;
															myPick3();
															
														}
	
	myPalette.group2.btnB = myPalette.group2.add("radiobutton",[125,1,165,30],"B");
	myPalette.group2.btnB.value = false;
	myPalette.group2.btnB.onClick = function ()
														{
															myPalette.group2.btnS.value = false;
															myPalette.group2.btnB.value = true;
															myPalette.group2.btnB.active = false;
															myPalette.group1.iconS.visible = false;
															myPalette.group1.iconB.visible = true;
															myPick3();
														}
	
	
	
	myPalette.group3 = myPalette.add('panel',[10,235,170,315],"object position");
	
	myPalette.group3.text0 = myPalette.group3.add('statictext',[10,10,80,30],"");
	myPalette.group3.text1 = myPalette.group3.add('statictext',[10,30,80,50],"x:");
	myPalette.group3.text2 = myPalette.group3.add('statictext',[10,50,80,70],"y:");
	
	myPalette.group3.textH = myPalette.group3.add('statictext',[90,10,150,30],"H");
	myPalette.group3.textS = myPalette.group3.add('statictext',[90,30,150,50],"S:");
	myPalette.group3.textB = myPalette.group3.add('statictext',[90,50,150,70],"B:");
	
	//マウスイベント
	myPalette.addEventListener('mousemove',myFunc);

}


buildUI();





